/********************************************************************************************************************************************************
*  author: Michael Mandel (mmandel@apple.com)                                                                                                           *
*  created: 5/30/06                                                                                                                                     *
*  Implements the basic fixed function features of OpenGL we use in shaders.                                                                            *
*  This relies on uniform parameters created by Coin and updated based on current openGL state, causing quite a few conditionals in the shader code...  *
*********************************************************************************************************************************************************/

//forward declare the common functionality needed (see fixed_function_common_vertex.glsl)
void fixed_funcComputeVertexColor(in vec3 normal, in vec4 ecPosition);
void fixed_funcComputeTexCoords(in vec3 normal, in vec4 ecPosition);
vec3 fnormal(void);

void main (void)
{
    vec3  transformedNormal;

    // Eye-coordinate position of vertex, needed in various calculations
    vec4 ecPosition = gl_ModelViewMatrix * gl_Vertex;

    // Do fixed functionality vertex transform
    gl_Position = ftransform();
    transformedNormal = fnormal();
    fixed_funcComputeVertexColor(transformedNormal, ecPosition);
    fixed_funcComputeTexCoords(transformedNormal, ecPosition);
    
    //test alpha ramp
    //gl_FrontColor.a = 1.0 - (gl_Vertex.y / 10.0);
    //gl_FrontColor.a *= gl_FrontColor.a;
    //truncate color channels so we can composite correctly later
    //gl_FrontColor = min(gl_FrontColor, vec4(gl_FrontColor.a, gl_FrontColor.a, gl_FrontColor.a, gl_FrontColor.a));
}